
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*               Januar 2019                         *
*****************************************************

*****************************************************
* Ordinale Regressionsmodelle
*  SPost-Befehle funktionieren hier nicht!?
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd "C:\Users\bruederl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
use  AllbReg, clear


*----------------------------------------
*   Datenaufbereitung
*----------------------------------------
recode rechts 1/3=1  4/6=2 7/10=3
label define relbl 1 "Links" 2 "Mitte" 3 "Rechts"
label value rechts relbl
tab rechts, m

replace   eink = eink/1000      //bessere Skalierung



******************************************
* Bsp.: Links/Rechts Selbsteinstufung 
******************************************
ologit   rechts alter bild eink frau ost
eststo                                     //funktioniert nur mit "estout"
oprobit  rechts alter bild eink frau ost
eststo                                     //funktioniert nur mit "estout"
regress  rechts alter bild eink frau ost
eststo                                     //funktioniert nur mit "estout"

* Vergleich der Modelle (funktioniert nur mit "estout")
esttab using LogProbLwm.rtf, r2 pr2 b(%6.3f)                ///
     mtitles("OLogit" "OProbit" "OLS") nonumbers            ///
     title(Vergleich von OLogit, OProbit und OLS) replace

* Odds-Ratios
ologit   rechts alter bild eink frau ost, or

/* McKelvey/Zavoina ist das empfohlene Fitmaß  [Funktioniert nicht mehr!?]
ologit   rechts alter bild eink frau ost
fitstat                                      //funktioniert nur mit "SPost"
* Standardisierte Koeffizienten
listcoef, std help                           //funktioniert nur mit "SPost"
*/


*--------------------------------------------
* "Parallel Regression Assumption"
*--------------------------------------------

* Plot der "parallel regression assumption"
twoway  ///
     (function y=invlogit(3.5-1*x), range (0 10) lcolor(blue)  lwidth(thick))  ///
	 (function y=invlogit(5  -1*x), range (0 10) lcolor(red)   lwidth(thick))  ///
	 (function y=invlogit(6  -1*x), range (0 10) lcolor(green) lwidth(thick)), ///
     ytitle("P(Y<=m)") ytitle(, size(large) margin(small))                     ///
     ylabel(0(0.1)1, labsize(medlarge) angle(horizontal) grid)                 ///
     xtitle("X", size(large) margin(small)) xlabel(0(1)10, labsize(medlarge))  ///
	 legend(pos(1) ring(0) row(3) order(1 2 3) lab(1 "P(Y<=1))")               ///
		     lab(2 "P(Y<=2))") lab(3 "P(Y<=3))") size(medlarge))               ///
     ysize(5)

* Test der "parallel regression assumption"
ologit   rechts alter bild eink frau ost
brant, detail                                //funktioniert nur mit "SPost"



*-----------------------------------------
* Profile-Plots
*-----------------------------------------

* Bildung und Alter
ologit   rechts alter bild eink frau ost
margins, at(alter=(18(5)83) bild=(8 18)) noatlegend predict(outcome(3))
marginsplot,   noci title("")                                                 ///
   plot1opts(lwidth(thick) lcolor(red)  msymbol(i))                           ///
   plot2opts(lwidth(thick) lcolor(blue) msymbol(i))                           ///
   ytitle("P(rechts=3)", size(large))                                         ///  
   ylabel(0(0.05)0.3, labsize(medlarge) angle(horizontal) grid format(%4.2f)) ///
   xtitle("Alter", size(large) margin(medsmall))                              ///  
   xlabel(20(10)80, labsize(medlarge))                                         ///
   legend(pos(7) ring(0) row(2) order(1 2) lab(1 "Bildung=8")                 ///
		     lab(2 "Bildung=18") size(medlarge))                              ///
   ysize(5)

* Alter kumulativ
ologit   rechts alter bild eink frau ost
prgen alter, from(18) to(83) generate(pr)           //funktioniert nur mit "SPost"
twoway connected prs1 prs2 prx,  lwidth(thick thick) lcolor(blue red)          ///
       msymbol(i i) ytitle("P kumuliert", size(large))                         ///  
       ylabel(0(0.1)1, labsize(medlarge) angle(horizontal) grid format(%3.1f)) ///
       xtitle("Alter", size(large) margin(medsmall))                           ///  
       xlabel(20(10)80, labsize(medlarge))                                     ///
       legend(pos(1) ring(0) row(2) order(1 2) lab(1 "P(Y<=1)")                ///
		     lab(2 "P(Y<=2)") size(medlarge))                                  ///
       ysize(5)

   
*-----------------------------------------
* Wahrscheinlichkeitsinterpretation
*-----------------------------------------

* Marginal Effects bzw. Discrete Change
ologit   rechts alter bild eink frau ost
prchange, help      //funktioniert nur, wenn SPost Ados geladen sind


* Average Marginal Effects bzw. Average Discrete Change
ologit   rechts alter bild eink i.frau i.ost
forvalues k=1/3 {
  margins, dydx(*) predict(outcome(`k'))
  marginsplot, horizontal xline(0) plotopts(connect(i))  ///Plot der AMEs
    title("")                                          ///
    xtitle("Effekt auf P(Rechts=`k')",                 ///
	       size(medium) margin(medsmall))              ///
    ytitle("")                                         ///
    xlabel(-0.1(0.025)0.1, grid labsize(small))        ///             
    ysize(5) saving(AME`k', replace)
}
graph combine AME1.gph AME2.gph AME3.gph,      ///
              rows(1) iscale(*1.4) xsize(9) ysize(3.5)

   
*------------------------------------------
* Interaktionseffekte
*------------------------------------------   

* Slope Interaktion: Ost##(Alter Alter2)
ologit   rechts bild eink frau i.ost##(c.alter c.alter#c.alter)  
test 1.ost#c.alter 1.ost#c.alter#c.alter

* Profile Plot
margins ost, at(alter=(18(5)83)) noatlegend predict(outcome(3))
marginsplot,   noci   title("PP Interaktion Ost#(Alter Alter2)")                                            ///
   plot1opts(lwidth(thick) lcolor(red)  msymbol(i))                    ///
   plot2opts(lwidth(thick) lcolor(blue) msymbol(i))                    ///
   ytitle("P(Rechts)", size(large))                                    ///  
   ylabel(0(0.05)0.5, labsize(medlarge) angle(horizontal) grid format(%4.2f))  ///
   xtitle("Alter", size(large) margin(medsmall))                        ///  
   xlabel(20(10)80, labsize(medlarge))                                  ///
   legend(pos(11) ring(0) row(2) order(1 2) lab(1 "Westdeutscher")      ///
		     lab(2 "Ostdeutscher") size(medlarge))                      ///
   ysize(5)

* Conditional-Effects-Plot
* Ost-Effekt varriert mit dem Alter
margins, at(alter=(18(2)82)) dydx(ost) noatlegend predict(outcome(3))
marginsplot,   recast(line) recastci(rline)                         ///
        plotopts(lwidth(thick) lcolor(blue))                        ///
		ciopts(lcolor(blue) lpattern(dash))                         ///
        ytitle("Differenz P(Rechts) zu West", size(medlarge))       ///  
        ylabel(-0.4(0.05)0.1, labsize(medlarge) angle(horizontal)   ///
		        grid format(%4.2f))                                 ///
        xtitle("Alter", size(large) margin(medsmall))               ///  
        xlabel(20(10)80, labsize(medlarge))                         /// 		
		yline(0, lcolor(red))                                       ///
		title("Konditionaler Marginaleffekt von 'Ost' und 95%-KI",  ///
		      size(large) margin(medium))                           ///
        ysize(5)   

		
*---------------------------------------
*  Generalisierte ordinales Logit
*---------------------------------------
* Dazu muss man das Programm "gologit2" laden
* net search gologit2       //gibt die Fundstellen
* net install st0097_1.pkg  //lädt das Paket direkt

* Alle Koeffizienten unrestringiert
gologit2   rechts alter bild eink frau ost
mfx, predict(p outcome(1))
mfx, predict(p outcome(2))
mfx, predict(p outcome(3))

* Test, welche die prop-odds verletzen, und Schätzung des entsprechenden
* "partial prop-odds" Modells
gologit2   rechts alter bild eink frau ost, autofit

* Interpretation
gologit2   rechts alter bild eink frau ost, pl //parallel lines für Alle (ologit)
mfx, predict(p outcome(1))
mfx, predict(p outcome(2))
mfx, predict(p outcome(3))
gologit2   rechts alter bild eink frau ost, npl(bild) //no parallel lines für "bild"
mfx, predict(p outcome(1))
mfx, predict(p outcome(2))
mfx, predict(p outcome(3))


* Cauchit
gologit2   rechts alter bild eink frau ost, npl(bild) link(ca)


* Stereotype Logit
slogit rechts alter bild eink frau ost
